-- @author QueuedResonance 2022

local Callbacks = {}

local ClientCommands = {}
local IgnoredCommands = {}

local CommandName = ZomboWinConfig.CommandName

--- Internal function for listening to server commands
-- @param module string, should be default "ZomboWin"
-- @param command string should be the name as the command in ZomboWinCommands
local function onServerCommand(module, command, args)
	if not isClient() or module ~= CommandName then return end

	if not ClientCommands[command] and not IgnoredCommands[command] then
		ClientCommands[moduleName] = require(string.format("ZomboWin/ClientCommands/%s", moduleName))
	end

	if ClientCommands[command] then
		ClientCommands[command](args)
	elseif not IgnoredCommands[command] then
		IgnoredCommands[command] = true
	end
end

--- Sends client commands to the server
-- @param command string should be the name of the command located in ZomboWinServerCommands
function Callbacks:sendClientCommand(command, ...)
	if not isClient() then return end

	sendClientCommand(getPlayer(), CommandName, command, {...})
end

--- Hook up event listeners
Events.OnServerCommand.Add(onServerCommand)

return Callbacks